cordova.define("cordova-plugin-eadp-nimble.CordovaNimble", function(require, exports, module) {
/* global cordova */
var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');

var CordovaNimble = function() {}

/**
 * Register a user to receive push notifications through the EADP Nimble
 * framework.
 * @param {string} uid The user ID to register for receiving push notifications
 * through Nimble.
 * @param {string} enabled The user's current opt-in state for push
 * notifications.
 * @param {Function} successCallback Callback to be invoked when registration
 * succeeds.
 * @param {Function} errorCallback Callback to be invoked on error.
 */
CordovaNimble.prototype.registerPushNotifications = function (
	uid,
	enabled,
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"SSFF",
		"CordovaNimble.registerPushNotifications",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"CordovaNimble",
		"registerPushNotifications",
		[uid, enabled]
	);
}

/**
 * Setup MTX.
 * @param {Function} cbSuccess Success callback function.
 * @param {Function} cbFail Failure callback function.
 * @public
 */
CordovaNimble.prototype.setupMTX = function (
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"FF",
		"CordovaNimble.setupMTX",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"CordovaNimble",
		"setupMTX",
		[]
	);
}

/**
 * Triggers an In-App-Purchase.
 * @param {string} mtxItemSku The item SKU to purchase.
 * @param {Function} cbSuccess Success callback function.
 * @param {Function} cbFail Failure callback function.
 * @public
 */
CordovaNimble.prototype.startMTXPurchase = function (
	sku,
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"SFF",
		"CordovaNimble.startMTXPurchase",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"CordovaNimble",
		"startMTXPurchase",
		[sku]
	);
}

CordovaNimble.prototype.grantMTXItem = function (
	transactionId,
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"SFF",
		"CordovaNimble.grantMTXItem",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"CordovaNimble",
		"grantMTXItem",
		[transactionId]
	);
}

/**
 * Finalizes an In-App-Purchase.
 * @param {boolean} verified Flag that indicates if UTAS was able to verify the purchase or not.
 * @param {string} mtxTransactionId The transaction ID to finalize.
 * @param {string} mtxItemType The type of the MTX item that was purchased.
 * @param {Function} cbSuccess Success callback function.
 * @param {Function} cbFail Failure callback function.
 * @public
 */
CordovaNimble.prototype.finalizeMTXPurchase = function (
	verified,
	transactionId,
	mtxItemType,
	successCallback,
	errorCallback
) {
	argscheck.checkArgs(
		"*SSFF",
		"CordovaNimble.finalizeMTXPurchase",
		arguments
	);

	exec(
		successCallback,
		errorCallback,
		"CordovaNimble",
		"finalizeMTXPurchase",
		[verified, transactionId, mtxItemType]
	);
}

module.exports = CordovaNimble;

});
